! NIKOLYA---NIKOLYA---NIKOLYA---NIKOLYA---NIKOLYA---NIKOLYA
! NIKOLYA---NIKOLYA---NIKOLYA---NIKOLYA---NIKOLYA---NIKOLYA
! NIKOLYA---NIKOLYA---NIKOLYA---NIKOLYA---NIKOLYA---NIKOLYA
      
      MODULE NIKOLYA
      implicit none
      double precision, allocatable :: AA(:,:), BB(:)
      double precision              :: DD
      double precision, allocatable :: spectr(:), asol(:), C(:)
      double precision              :: Nspectr,Nint
      double precision, allocatable :: solutions(:,:)
      integer :: Nsolutions
      integer :: Nbins
      double precision, allocatable :: obins(:), dom(:)
      double precision, allocatable :: ogrid(:), dm(:)
      double precision                  :: Dfactor 
      double precision, allocatable :: D4factor(:)
      double precision                  :: Norm
      integer :: iter, i, j, o
      
! Initials
     !Norm=1.0d2
     !Dfactor=1.0d0
     !To remove oversmoothing Norm --> 1.0d6, Dfactor --> 0.5, 0.25
      
      double precision :: x,y,z,z0 
      Real*16 :: xx, yy
      REAL*16, ALLOCATABLE :: Matrix(:,:), invMatrix(:,:)
      INTEGER :: nmat, ErrorFlag
      
      CONTAINS
      
      SUBROUTINE GLADIM(Nso_kaka,Nbi_kaka)
      INTEGER,INTENT(IN) :: Nso_kaka,Nbi_kaka
      
      Nsolutions=Nso_kaka
      Nbins=Nbi_kaka
      
      allocate(obins(0:Nbins),dom(Nbins)) 
      allocate(ogrid(Nbins),dm(Nbins-1)) 
      allocate(D4factor(Nbins))
      D4factor(1:Nbins)=0.5d0*Dfactor
      
      allocate(solutions(Nsolutions,Nbins))
      allocate(asol(Nbins),spectr(Nbins))
      allocate(AA(Nsolutions,Nsolutions))
      allocate(BB(Nsolutions),C(Nsolutions))
      
      open(1,file='poprobui_sgladi.in')
      do i=1,Nsolutions;  do o=0,Nbins
      IF(o<Nbins) then    
      read(1,*) iter, obins(o), solutions(iter,o+1)
      else
      read(1,*) iter, obins(o)
      endif
      enddo; enddo
      close(1)
      
!      do i=0,Nbins;  obins(i)=(1.5/Nbins)*i; enddo
      do i=1,Nbins;  ogrid(i)= (obins(i)+obins(i-1))/2.d0; enddo
      do i=1,Nbins;    dom(i)= obins(i)-obins(i-1); enddo     
      do i=1,Nbins-1;   dm(i)= ogrid(i)-ogrid(i+1); enddo    
      
          
      Nint=0.d0; do o=1,Nbins; 
      Nint=Nint+solutions(1,o)*dom(o); enddo
      print*, 'initial Nint=', Nint
                               
       C=1.d0/Nsolutions                   ! simple average
       x=0.d0; do o=1,Nbins; y=0.d0
         do i=1,Nsolutions; y=y+C(i)*solutions(i,o); enddo
         asol(o)=y ; IF(asol(o)<1.d-06) then; 
         asol(o)=1.d-06; D4factor(o)=0.01d0; endif  
         x=x+asol(o)*dom(o);  enddo  ! averaged solution, norm
       spectr=asol; Nspectr=x
       call objective              ! its objective
      
       open(1,file='s0.dat')       ! write it
       do o=1,Nbins; write(1,*) ogrid(o), asol(o) 
       enddo; close(1) 
      
      do iter=1,10        ! solving for coefficients   
      
      call matrixini; nmat=Nsolutions  
      ALLOCATE(Matrix(nmat,nmat),invMatrix(nmat,nmat))
      Matrix=AA
      CALL FindInv(Matrix, invMatrix, nmat, ErrorFlag) 
      
      y=0.d0;  do j=1,nmat; xx=0.d0; 
               do i=1,nmat; xx=xx-invMatrix(j,i)*BB(i) ; enddo; 
               C(j)=xx/2.d0; y=y+C(j); enddo ; C=C/y        
      
      deallocate(Matrix,invMatrix) 
               
      Nspectr=0.d0; do o=1,Nbins; y=0.d0
         do i=1,Nsolutions; y=y+C(i)*solutions(i,o); enddo    
      spectr(o)=y; Nspectr=Nspectr+spectr(o)*dom(o); enddo  ! new solution
         
      call objective                                    ! its objective
      asol=spectr; D4factor=0.5d0 
      do o=1,Nbins; IF(asol(o)<1.d-06) then; 
                    asol(o)=1.d-06; D4factor(o)=0.01d0; endif ; 
      enddo 
      
      IF(iter==1) then              ! write it after first iteration
       open(1,file='s1.dat')
       do o=1,Nbins; write(1,*) ogrid(o), spectr(o); enddo
       close(1) 
      ELSE                          ! write after iterations
       open(1,file='smooth.dat')
       do o=1,Nbins; write(1,*) ogrid(o), spectr(o); enddo
       close(1)     
      ENDIF
       
      enddo   ! iterations cycle
     
      deallocate(AA,BB,solutions,asol,spectr,C)
      
      !PRINT*,'job done'      
      
      END SUBROUTINE GLADIM
!_________________________________________________      
	  subroutine objective
      implicit none
      integer :: o 
      double precision :: x, x1
           
      x=0.d0      
      do o=1,Nbins-1          	                     
         x=x + Dfactor*(spectr(o)-spectr(o+1))**2     
      enddo
      !print*, 'objective D', x
      x1=x
      
      do o=1,Nbins          	                          
         x=x + D4factor(o)*((spectr(o)-asol(o))/asol(o))**2
      enddo
      !print*, 'objective T', x-x1 
      x1=x
      
      x=x+Norm*(Nspectr-Nint)**2
      !print*, 'objective N', x-x1 
      
      !print*, 'objective total', y, x    
      
 	  end subroutine objective    
!_________________________________________________      
	  subroutine matrixini
      implicit none
      integer :: i, j, o, oo 
      double precision :: x, y

! first derivative      
      do i=1,Nsolutions; do j=1,Nsolutions
        x=0.d0  
        do o=1,Nbins-1;   	  
        y=   solutions(i,o)-solutions(i,o+1)
        y=y*(solutions(j,o)-solutions(j,o+1))
         x=x + Dfactor*y     
	    enddo  
      AA(i,j)=x
      enddo; enddo
      
! deviation from target      
      do i=1,Nsolutions; do j=1,Nsolutions
        x=0.d0  
        do o=1,Nbins;
         y=D4factor(o)/(asol(o)*asol(o))   
         x=x + y*solutions(i,o)*solutions(j,o)     
	    enddo  
      AA(i,j)=AA(i,j)+x
      enddo; enddo
      
      do i=1,Nsolutions
        x=0.d0  
        do o=1,Nbins;
         y=D4factor(o)/asol(o)   
         x=x -2.d0*y*solutions(i,o)
	    enddo  
      BB(i)=x
      enddo
      
        x=0.d0  
        do o=1,Nbins;   	                     
         x=x+D4factor(o)     
	    enddo  
      DD=x

! Normalization
      do i=1,Nsolutions; do j=1,Nsolutions
        x=0.d0  
        do o=1,Nbins; do oo=1,Nbins  	                     
      x=x+Norm*solutions(i,o)*solutions(j,oo)*dom(o)*dom(oo)     
	    enddo; enddo  
      AA(i,j)=AA(i,j)+x
      enddo; enddo
      
      do i=1,Nsolutions
        x=0.d0  
        do o=1,Nbins;   	                     
         x=x -2.d0*Norm*solutions(i,o)*dom(o)*Nint
	    enddo  
      BB(i)=BB(i)+x
      enddo
      
      DD=DD+Norm*Nint*2
           
 	  end subroutine matrixini
!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    
      SUBROUTINE FINDInv(matrix, inverse, n, errorflag)
  	  IMPLICIT NONE
!Declarations
	  INTEGER, INTENT(IN) :: n
	  INTEGER, INTENT(OUT) :: errorflag  !Return error status. -1 for error, 0 for normal
	  REAL*16, INTENT(IN),  DIMENSION(n,n) :: matrix  !Input matrix
	  REAL*16, INTENT(OUT), DIMENSION(n,n) :: inverse !Inverted matrix
	
	  LOGICAL :: FLAG = .TRUE.
	  INTEGER :: i, j, k, l
	  REAL*16 :: m
	  REAL*16, DIMENSION(n,2*n) :: augmatrix !augmented matrix
	
!Augment input matrix with an identity matrix
	  DO i = 1, n
		DO j = 1, 2*n
			IF (j <= n ) THEN
				augmatrix(i,j) = matrix(i,j)
			ELSE IF ((i+n) == j) THEN
				augmatrix(i,j) = 1.d0
			Else
				augmatrix(i,j) = 0.d0
			ENDIF
		END DO
	  END DO
	
!Reduce augmented matrix to upper traingular form
	  DO k =1, n-1
		IF (augmatrix(k,k) == 0.d0) THEN
			FLAG = .FALSE.
			DO i = k+1, n
				IF (augmatrix(i,k) /= 0) THEN
					DO j = 1,2*n
						augmatrix(k,j) = augmatrix(k,j)+augmatrix(i,j)
					END DO
					FLAG = .TRUE.
					EXIT
				ENDIF
				IF (FLAG .EQV. .FALSE.) THEN
					PRINT*, "Matrix is non - invertible"
					inverse = 0.d0
					errorflag = -1.d0
					return
				ENDIF
			END DO
		ENDIF
		DO j = k+1, n			
			m = augmatrix(j,k)/augmatrix(k,k)
			DO i = k, 2*n
				augmatrix(j,i) = augmatrix(j,i) - m*augmatrix(k,i)
			END DO
		END DO
	  END DO
	
!Test for invertibility
	  DO i = 1, n
		IF (augmatrix(i,i) == 0.d0) THEN
			PRINT*, "Matrix is non - invertible"
			inverse = 0.d0
			errorflag = -1
			return
		ENDIF
	  END DO
	
!Make diagonal elements as 1
	  DO i = 1 , n
		m = augmatrix(i,i)
		DO j = i , (2 * n)				
			   augmatrix(i,j) = (augmatrix(i,j) / m)
		END DO
	  END DO
	
!Reduced right side half of augmented matrix to identity matrix
  	  DO k = n-1, 1, -1
		DO i =1, k
		m = augmatrix(i,k+1)
			DO j = k, (2*n)
				augmatrix(i,j) = augmatrix(i,j) -augmatrix(k+1,j) * m
			END DO
		END DO
	  END DO				
	
!store answer
	   DO i =1, n
		DO j = 1, n
			inverse(i,j) = augmatrix(i,j+n)
		END DO
	   END DO
	    errorflag = 0
      END SUBROUTINE FINDinv   
    
         end
! NIKOLYA END NIKOLYA END NIKOLYA END NIKOLYA END NIKOLYA END 

         
! MAIN MAIN MAIN

      PROGRAM statistics_analisis
    
     USE NIKOLYA

      IMPLICIT NONE

      INTEGER :: ivoid,perf_runs,succ_runs,num_his,num_his_big
      INTEGER :: rec_len,rec_len_big,cubatif,cubatif_big,kernel_type
      LOGICAL :: OBJECTIVE_USE, NORMA_USE
      REAL*8 :: o_low,o_high,n_low,n_high,beta
      
      LOGICAL :: REFINEMENT
      
      INTEGER :: brek,portu_run=0
      REAL*8,ALLOCATABLE,DIMENSION(:) :: om,his_glob
      REAL*8,ALLOCATABLE,DIMENSION(:,:) :: his_loc
      REAL*8,ALLOCATABLE,DIMENSION(:) :: om_trun,his_trun
      
      REAL*8,ALLOCATABLE,DIMENSION(:) :: om_big,his_glob_big
      REAL*8,ALLOCATABLE,DIMENSION(:,:) :: his_loc_big
      REAL*8,ALLOCATABLE,DIMENSION(:) :: om_trun_big,his_trun_big
      
      REAL*8,ALLOCATABLE,DIMENSION(:) :: budu, budu_big
      REAL*8,ALLOCATABLE,DIMENSION(:) :: budu_tilda, budu_big_tilda
      REAL*8,ALLOCATABLE,DIMENSION(:,:)  :: po_of
      REAL*8,DIMENSION(8) :: into
! Stability analysis
      REAL*8,DIMENSION(0:5000) :: maxde,h_maxde,maxme,h_maxme
      REAL*8 :: ma_maxde,mi_maxde,av_maxde
      REAL*8 :: ma_maxme,mi_maxme,av_maxme
      REAL*8 :: sha_sta
      INTEGER,PARAMETER :: i_hissta=100, i_hissta_2=5000
      INTEGER :: i_fli
! Stability anzaces analysis
      REAL*8   :: om_av,z_av
      REAL*8 :: om_min,om_max,zz_min,zz_max
      REAL*8 :: z_tota1,dis_1
      REAL*8 :: nor_ku=0.0d0,nor_ge=0.0d0,sh_his,sh_his_big,sukno
      INTEGER :: i_anz
! Errorbars analysis
      INTEGER :: num_his_gri,j_grid,j_hist,j_l,j_r,j_ku
      REAL*8 :: sha_his_gri,O_L,O_R,SS_0,shg2
      REAL*8,ALLOCATABLE,DIMENSION(:,:) :: value,his_loc_succ 
      REAL*8,ALLOCATABLE,DIMENSION(:) :: om_his_gri, ome_tut, average
      REAL*8,ALLOCATABLE,DIMENSION(:) :: stan_dev, maxrage, minrage 
! Kolya smoothening analysis
      REAL*8,ALLOCATABLE,DIMENSION(:,:) :: his_selected
      REAL*8,ALLOCATABLE,DIMENSION(:) :: preci_runs,preci_runs_ord
      INTEGER :: N_salut_max
      INTEGER,PARAMETER :: N_salut_not_more=60, N_bins_ko_max=80
      INTEGER :: N_salut,N_bins_ko,j_baba 
      LOGICAL :: Kolya_possible
      REAL*8 :: preci_vot
! Kolya improvements analysis
      REAL*8,ALLOCATABLE,DIMENSION(:,:) :: Pomog
      INTEGER :: i_pomog      
      REAL*8 :: bolshe,menshe
      
      
101   FORMAT(1X,6(F12.8,1X)) 
      
      PRINT*,'     '      
      PRINT*,'**Processing code obrab_x01.f90 July 28 2015, 16:35 ********'      
      PRINT*,'     '
      
! reading how to smooth data      
      OPEN(UNIT=4,FILE='brek.in');   
          READ(4,*)brek
      CLOSE(4)
            
! reading information about kernel and temperature
      OPEN(UNIT=4,FILE='trans_obrab.dat'); 
         READ(4,*)kernel_type;
         READ(4,*)beta
         READ(4,*)ivoid
      CLOSE(4)

      PRINT*," Kernel type: ", kernel_type
      
! precision and norma is set to any     
      OPEN(UNIT=4,FILE="precision.in")
         READ(4,*)REFINEMENT                           !refinemnet if .TRUE.
         READ(4,*)OBJECTIVE_USE,o_low,o_high  !objectvive in [o_low,o_high] if .TRUE.
         READ(4,*)NORMA_USE,n_low,n_high       !norma in [n_low,n_high] if .TRUE.
         READ(4,*)num_his_gri                            !numb grids to establish errorbars
         READ(4,*)N_salut_max                           !Max NUmber solutions for smoothening
         READ(4,*)Dfactor !Was 1.0d0; remove oversmoothing --> 0.5, 0.25
         READ(4,*)Norm    !Was 1.0d2, remove oversmoothing --> 1.0d6
      CLOSE(4)
      
      IF(N_salut_max>N_salut_not_more)THEN
          PRINT*,"Decrease N_salut_max!!!"
          STOP
      ENDIF    
      
      IF(REFINEMENT)THEN
          PRINT*,"******  THIS IS REFINEMENT ******************* "
      ELSE
          PRINT*,"******  THIS IS ORDINARY   ******************* "
      ENDIF
      
      
      IF(.NOT. OBJECTIVE_USE)THEN
          PRINT*,"No precision restrictions"
          o_low=0.0d0; o_high=HUGE(1.0d0)
      ENDIF    
      IF(.NOT. NORMA_USE)THEN
          PRINT*,"No norma restrictions"
          n_low=0.0d0; n_high=HUGE(1.0d0)
      ENDIF    
      IF(OBJECTIVE_USE)THEN
       PRINT'("Precisiom restrictions: O_low / O_high :",2(2x,ES10.3))',&
       O_low, O_high
      ENDIF
      IF(NORMA_USE)THEN
        PRINT'("Norma restrictions: N_low / N_high :",2(2x,ES10.3))',& 
       N_low,N_high
      ENDIF
! reading number of succesfull rans and allocating
      IF(REFINEMENT)THEN
         OPEN(UNIT=4,FILE='ref_run.dat') 
      ELSE    
         OPEN(UNIT=4,FILE='glo_run.dat')
      ENDIF
         READ(4,*)ivoid,perf_runs,succ_runs; 
      CLOSE(4)
      ALLOCATE(po_of(succ_runs,8))

! reading number of histo cells for MAIN HISTOGRAM and allocating
      OPEN(UNIT=4,FILE='om_grid.dat')
      READ(4,*)num_his 
      CLOSE(4);    
      ALLOCATE(om(0:num_his), his_glob(0:num_his))
      ALLOCATE(his_loc(succ_runs,0:num_his),budu(0:num_his))      
      ALLOCATE(budu_tilda(0:num_his))
!  reading the grid of data     
      OPEN(UNIT=4,FILE='om_grid.dat')
         READ(4,*)num_his,om(0:num_his); 
      CLOSE(4); 
      sh_his=om(1)-om(0);


! Establishing dimensions for errorbars and allocating
      sha_his_gri = ( om(num_his)-om(0) ) / num_his_gri
      shg2 = sha_his_gri / 2.0d0
      IF(sha_his_gri<=sh_his)THEN
         PRINT*,"Too small step for establishing errorbars" 
         STOP
      ENDIF    
      ! columns grid for collecting values inside column [j,j+1]      
      ALLOCATE(om_his_gri(0:num_his_gri)) 
      DO j=0,num_his_gri
         om_his_gri(j)= om(0) + sha_his_gri*j 
      ENDDO    
      ALLOCATE(value(succ_runs,0:num_his_gri-1)) 
      ALLOCATE(his_loc_succ(succ_runs,0:num_his)) 
      ALLOCATE(ome_tut(0:num_his_gri-1))
      ! putting the omegas into the centers of columns      
      DO j=0,num_his_gri-1
         ome_tut(j) = (om_his_gri(j)+om_his_gri(j+1))*0.5d0 
      ENDDO          
      ALLOCATE(average(0:num_his_gri-1))
      ALLOCATE(stan_dev(0:num_his_gri-1))
      ALLOCATE(maxrage(0:num_his_gri-1))
      ALLOCATE(minrage(0:num_his_gri-1))
      
      
! reading number of histo cells for BIG HISTOGRAM and allocating
      OPEN(UNIT=4,FILE='om_grid_big.dat')
      READ(4,*)num_his_big 
      CLOSE(4);    
      ALLOCATE(om_big(0:num_his_big), his_glob_big(0:num_his_big))
      ALLOCATE(his_loc_big(succ_runs,0:num_his_big), &
                     budu_big(0:num_his_big)) 
      ALLOCATE(budu_big_tilda(0:num_his_big))
      ALLOCATE(preci_runs(succ_runs),preci_runs_ord(succ_runs))
!  reading the grid of data     
      OPEN(UNIT=4,FILE='om_grid_big.dat')
         READ(4,*)num_his_big,om_big(0:num_his_big); 
      CLOSE(4); 
      sh_his_big=om_big(1)-om_big(0);
      
      
! reading parameters of the solutions      
      IF(REFINEMENT)THEN
         OPEN(7,FILE='ref_each.dat') 
      ELSE    
         OPEN(7,FILE='glo_each.dat')
      ENDIF   
      DO j=1,succ_runs; 
         READ(7,*)into(1:8)
         po_of(j,1:8)=into(1:8)
      ENDDO      
      CLOSE(7)

! defining parameters of OBJECTIVE DISTRIBUTIONS
      av_maxme=0.0d0
      mi_maxme=HUGE(mi_maxme); ma_maxme=0.0d0
      DO j=1,succ_runs;
        av_maxme=av_maxme+(1.0/po_of(j,1))/succ_runs;
        IF(1.0/po_of(j,1)<mi_maxme)mi_maxme=1.0/po_of(j,1) 
        IF(1.0/po_of(j,1)>ma_maxme)ma_maxme=1.0/po_of(j,1) 
      ENDDO      
      PRINT'("Min / Ave / Max Objective: " &
       1X,ES10.3," / ",ES10.3," / ",ES10.3)',mi_maxme,av_maxme,ma_maxme
! making histogram of objectives      
      sha_sta=(ma_maxme-mi_maxme)/i_hissta;
      DO i_fli=0,i_hissta;
        h_maxme(i_fli)=0.0d0;
        maxme(i_fli)=mi_maxme+i_fli*sha_sta;  
      ENDDO  
      DO j=1,succ_runs;
        DO i_fli=0,i_hissta; 
          IF(1.0/po_of(j,1)<maxme(i_fli)+sha_sta)THEN;
            h_maxme(i_fli)=h_maxme(i_fli)+1.0d0; EXIT;
          ENDIF
        ENDDO
      ENDDO            
      OPEN(7,FILE='measur.dat')
      DO i_fli=0,i_hissta; 
         WRITE(7,*)maxme(i_fli),'  ',h_maxme(i_fli); 
      ENDDO      
      CLOSE(7)


! defining parameters of MAX-DEVIATIONS DISTRIBUTIONS
      av_maxde=0.0d0
      mi_maxde=HUGE(mi_maxde); ma_maxde=0.0d0
      DO j=1,succ_runs;
        av_maxde=av_maxde+po_of(j,2)/succ_runs;
        IF(po_of(j,2)<mi_maxde)mi_maxde=po_of(j,2) 
        IF(po_of(j,2)>ma_maxde)ma_maxde=po_of(j,2) 
      ENDDO      
      PRINT'("Min / Ave / Max deviation: " &
      ,1X,ES10.3," / ",ES10.3," / ",ES10.3)',mi_maxde,av_maxde,ma_maxde
! making histogram of max-deviations    
      sha_sta=(ma_maxde-mi_maxde)/i_hissta;
      DO i_fli=0,i_hissta;
        h_maxde(i_fli)=0.0d0;
        maxde(i_fli)=mi_maxde+i_fli*sha_sta;  
      ENDDO
      DO j=1,succ_runs;
        DO i_fli=0,i_hissta; 
          IF(po_of(j,2)<maxde(i_fli)+sha_sta)THEN;
            h_maxde(i_fli)=h_maxde(i_fli)+1.0d0; EXIT;
          ENDIF
        ENDDO
      ENDDO      
      OPEN(7,FILE='deviat.dat')
      DO i_fli=0,i_hissta; 
         WRITE(7,*)maxde(i_fli),'  ',h_maxde(i_fli); 
      ENDDO      
      CLOSE(7)



! Making NORMALIC file
      OPEN(UNIT=7,FILE="normalic.dat")
         DO i=1,succ_runs
             WRITE(7,*)po_of(i,6),' ',po_of(i,1),' ',po_of(i,8)        
         ENDDO    
      CLOSE(7)

! ---- M A I N   H I S T O G R A M    B E G I N S ---------------      
! reading MAIN HISTOGRAMS OF THE SOLUTIONS      
      portu_run=0
      INQUIRE(IOLENGTH=rec_len)om(0:num_his)  !RecordLengthForDirectAccess
      IF(REFINEMENT)THEN
         OPEN(UNIT=4,       FILE='ref_spec.dat' ,ACCESS='direct', &
          RECL=rec_len, FORM='unformatted')
      ELSE    
         OPEN(UNIT=4,       FILE='glo_spec.dat' ,ACCESS='direct', &
          RECL=rec_len, FORM='unformatted')
      ENDIF
      his_glob(0:num_his)=0.0d0
      DO j=1,succ_runs
      READ(4,REC=j)budu_tilda(0:num_his)
         SELECT CASE(kernel_type)
         CASE(0,1,2,4,5,6,7)
             budu(0:num_his) = budu_tilda(0:num_his)    
         CASE(3) 
            CALL UN_TILDEFY(beta,num_his,om,budu_tilda,budu)
         CASE DEFAULT
            STOP'Ni figa sebe'
         END SELECT    
         his_loc(j,0:num_his)=budu(0:num_his)
      IF( 1.0d0/po_of(j,1) >= o_low .AND. 1.0d0/po_of(j,1) <= o_high & 
         .AND. po_of(j,6) >= n_low .AND. po_of(j,6) <= n_high )THEN
      his_glob(0:num_his) &
           = his_glob(0:num_his)+his_loc(j,0:num_his)
      portu_run=portu_run+1
      his_loc_succ(portu_run,0:num_his)=his_loc(j,0:num_his)
      ENDIF
      ENDDO; 
      CLOSE(4)
! selecting restrictions
      IF(portu_run>0)THEN
        his_glob(0:num_his)=his_glob(0:num_his)/portu_run
      ELSE
      PRINT*,'Sorry, you want too much. No runs with such parameters'
      ENDIF
! writing MAIN HISTOGRAM      
      OPEN(4,FILE='final.dat')
      DO j=0,num_his; WRITE(4,*)om(j),'  ',his_glob(j); ENDDO      
      CLOSE(4)     
! making and writing COARSE GRAIN MAIN HISTOGRAM      
      cubatif = (num_his/brek)-1
      ALLOCATE(om_trun(0:cubatif), his_trun(0:cubatif))
      om_trun(0:cubatif)=0.0d0; his_trun(0:cubatif)=0.0d0
      DO j=0,cubatif
         DO i=1,brek
            his_trun(j)=his_trun(j)+his_glob(brek*j+i)/brek
            om_trun(j)=om_trun(j)+om(brek*j+i)/brek
         ENDDO
      ENDDO
      OPEN(4,FILE='final_tr.dat')
      DO j=0,cubatif; 
         WRITE(4,*)om_trun(j),'  ',his_trun(j); 
      ENDDO      
      CLOSE(4)
! ---   ESTABLISHING ERRORBARS FOR MAIN HISTOGRAM
      IF(portu_run>0)THEN
         suc_ru: DO j=1,portu_run
            grid: DO j_grid=0,num_his_gri-1
               O_L=om_his_gri(j_grid); O_R=om_his_gri(j_grid+1)
               j_l=0
               DO j_hist=0,num_his; 
                  IF(om(j_hist)>O_L)THEN;
                     j_l=j_hist-1; EXIT 
                  ENDIF    
               ENDDO    
               j_r=num_his
               DO j_hist=0,num_his; 
                  IF(om(j_hist)>O_R)THEN;
                     j_r=j_hist; EXIT 
                  ENDIF    
               ENDDO    
               IF(j_r<j_l+2)THEN
                   PRINT*,"something wring with shag"
                   PRINT*,"j_l - j_r  : ", j_l,"  -  ",j_r
                   STOP
               ENDIF    
               SS_0 = (om(j_l+1)-O_L)*his_loc_succ(j,j_l)
               SS_0 = SS_0 + (O_R -om(j_r-1))*his_loc_succ(j,j_r-1)
               IF(j_r-j_l>2)THEN
                  DO j_ku=j_l+1,j_r-2
                     SS_0 = SS_0 + sh_his * his_loc_succ(j,j_ku) 
                  ENDDO   
               ENDIF
               value(j,j_grid)=SS_0/sha_his_gri
            ENDDO grid    
         ENDDO suc_ru
         ! Calculating average
         average(0:num_his_gri-1)=0.0d0
         DO j=1,portu_run
             average(0:num_his_gri-1) =  average(0:num_his_gri-1) &
             + ( value(j,0:num_his_gri-1) / portu_run )
         ENDDO    
         !calculating standard deviation
         stan_dev(0:num_his_gri-1)=0.0d0
         DO j_grid=0,num_his_gri-1
            DO j=1,portu_run
             stan_dev(j_grid) =  stan_dev(j_grid) + &
                    ( average(j_grid) - value(j,j_grid)  )**2
            ENDDO
            stan_dev(j_grid) = SQRT( stan_dev(j_grid)/portu_run ) 
            maxrage(j_grid)=average(j_grid)+stan_dev(j_grid)
            minrage(j_grid)=average(j_grid)-stan_dev(j_grid)
         ENDDO
      ELSE
         PRINT*,"pourtu_run=0, ERRORBARS CANNOT BE ESTABLISHED!!!" 
      ENDIF    
      !Writing file for errorbars
      OPEN(UNIT=4,FILE="errobars.dat")
      DO  j_grid=0,num_his_gri-1
          WRITE(4,101)ome_tut(j_grid), &
           minrage(j_grid),average(j_grid),maxrage(j_grid)
      ENDDO    
      CLOSE(4)
      !Writing file for GNUPLOT errorbars      
      OPEN(UNIT=4,FILE="errobars_GNU.dat")
      DO  j_grid=0,num_his_gri-1
          WRITE(4,101)ome_tut(j_grid),average(j_grid), &
           ome_tut(j_grid)-shg2, ome_tut(j_grid)+shg2, &
           minrage(j_grid),maxrage(j_grid)
      ENDDO    
      CLOSE(4)
      !Writing second file for GNUPLOT errorbars      
      OPEN(UNIT=4,FILE="errobars_GNU2.dat")
      DO  j_grid=0,num_his_gri-1
          WRITE(4,101)ome_tut(j_grid),average(j_grid), & 
           minrage(j_grid),maxrage(j_grid)
      ENDDO    
      CLOSE(4)
      !Writing file for ORIGIN errorbars
      OPEN(UNIT=4,FILE="errobars_ORI.dat")
      DO  j_grid=0,num_his_gri-1
          WRITE(4,101)ome_tut(j_grid), &
                            average(j_grid),stan_dev(j_grid),shg2
      ENDDO    
      CLOSE(4)
! ---- M A I N   H I S T O G R A M   E  N D S ---------------      

      
      
! ---- B I G   H I S T O G R A M    B E G I N S ---------------      
! Reading histogram 
      portu_run=0
      INQUIRE(IOLENGTH=rec_len_big)om_big(0:num_his_big)  !RecordLengthForDirectAccess
      IF(REFINEMENT)THEN
         OPEN(UNIT=4,       FILE='ref_spec_big.dat' ,ACCESS='direct', &
          RECL=rec_len_big, FORM='unformatted')
      ELSE    
         OPEN(UNIT=4,       FILE='glo_spec_big.dat' ,ACCESS='direct', &
          RECL=rec_len_big, FORM='unformatted')
      ENDIF   
      his_glob_big(0:num_his_big)=0.0d0
      DO j=1,succ_runs
      preci_runs(j)=1/po_of(j,1)    
      read(4,REC=j)budu_big_tilda(0:num_his_big)
         SELECT CASE(kernel_type)
         CASE(0,1,2,4,5,6,7)
             budu_big(0:num_his_big) = budu_big_tilda(0:num_his_big)    
         CASE(3) 
            CALL UN_TILDEFY(beta,num_his_big,om_big,budu_big_tilda,budu_big)
         CASE DEFAULT
            STOP'Ni figa sebe'
         END SELECT    
         his_loc_big(j,0:num_his_big)=budu_big(0:num_his_big)
      IF( 1.0d0/po_of(j,1) >= o_low .AND. 1.0d0/po_of(j,1) <= o_high & 
         .AND. po_of(j,6) >= n_low .AND. po_of(j,6) <= n_high )THEN
      his_glob_big(0:num_his_big) & 
           = his_glob_big(0:num_his_big)+his_loc_big(j,0:num_his_big)
      portu_run=portu_run+1
      ENDIF
      ENDDO; 
      CLOSE(4)
! selecting restrictions
      IF(portu_run>0)THEN
        his_glob_big(0:num_his_big)= &
          his_glob_big(0:num_his_big)/portu_run
      ELSE
      PRINT*,'Sorry, you want too much. No runs with such parameters'
      ENDIF
! writing BIG HISTOGRAM      
      OPEN(4,FILE='final_big.dat')
      DO j=0,num_his_big; 
          WRITE(4,*)om_big(j),'  ',his_glob_big(j); 
      ENDDO      
      CLOSE(4)     
! making and writing COARSE GRAIN BIG HISTOGRAM      
      cubatif_big = (num_his_big/brek)-1
      ALLOCATE(om_trun_big(0:cubatif_big),his_trun_big(0:cubatif_big))
      om_trun_big(0:cubatif_big)=0.0d0; 
      his_trun_big(0:cubatif_big)=0.0d0
      DO j=0,cubatif_big
         DO i=1,brek
            his_trun_big(j)=his_trun_big(j)+his_glob_big(brek*j+i)/brek
            om_trun_big(j)=om_trun_big(j)+om_big(brek*j+i)/brek
         ENDDO
      ENDDO
      OPEN(4,FILE='final_tr_big.dat')
      DO j=0,cubatif_big; 
         WRITE(4,*)om_trun_big(j),'  ',his_trun_big(j); 
      ENDDO      
      CLOSE(4)
! ---- B I G   H I S T O G R A M   E  N D S ---------------      
!
! --- MAKES KOLYA SMOOTHENING

! checkin that number of bins is not too big
      Kolya_possible = .TRUE.
      IF(num_his_big>N_bins_ko_max)THEN
          PRINT*,"Not bale to perform Kolya smoothening"
          PRINT*,"Too many bins in BIG hystogram >",N_bins_ko_max
          PRINT*,"Enlarge N_bins_ko_max"
          Kolya_possible = .FALSE.
          GOTO 8899
      ELSE
          N_bins_ko=num_his_big
      ENDIF    
      
      ALLOCATE(his_selected(N_salut_max,0:N_bins_ko))

! selecting not more than N_salut_max solutions     
      IF(succ_runs>N_salut_max)THEN; !selecting N_salut_max best solutions
          CALL ORDERD_SMALL(succ_runs,preci_runs,preci_runs_ord)
          !PRINT*,preci_runs_ord; PAUSE
          preci_vot=preci_runs_ord(N_salut_max)
          PRINT*,"Border precision for Kolya: ",preci_vot
          N_salut=N_salut_max
          j_baba=0
          DO j=1,succ_runs 
             IF(preci_runs(j)<=preci_vot)THEN
                 j_baba=j_baba+1
                 IF(j_baba>N_salut_max)THEN
                    PRINT*,"j_baba was large. Exits cycle-->"
                    PRINT*,"j_baba = ",j_baba
                    PRINT*,"N_salut_max = ",N_salut_max
                    EXIT
                 ENDIF        
                 his_selected(j_baba,0:N_bins_ko)=his_loc_big(j,0:N_bins_ko)
                 !PRINT*,j_baba,preci_runs(j),preci_vot
             ENDIF    
          ENDDO    
      ELSE; ! taking just as many solutions as at hand now
          N_salut=succ_runs   
          DO j=1,N_salut
             his_selected(j,0:N_bins_ko)=his_loc_big(j,0:N_bins_ko) 
          ENDDO    
      ENDIF
         
      PRINT*,"Smoothening pars N_salut/N_bins_ko : ",  N_salut, N_bins_ko
      
      OPEN(UNIT=4,FILE="poprobui_sgladi.in")
      DO j=1,N_salut
          DO j_grid=0,N_bins_ko
             WRITE(4,*)j,om_big(j_grid),his_selected(j,j_grid)        
          ENDDO; 
      ENDDO;        
      CLOSE(4)
      
      PRINT*,"Enter gladim"
      CALL GLADIM(N_salut,N_bins_ko)
      PRINT*,"Finish gladim"
      
8899  CONTINUE      
      
!----FINISHES KOLYA SMOOTHENING----------------------      
      
! ---- K O L Y A   H I S T O G R A M    B E G I N S ---------------      
! reading KOLYA HISTOGRAMS OF THE SOLUTIONS 
      portu_run=0
      INQUIRE(IOLENGTH=rec_len)om(0:num_his)  !RecordLengthForDirectAccess
      IF(REFINEMENT)THEN
         OPEN(UNIT=4,       FILE='ref_spec_kol.dat' ,ACCESS='direct', &
          RECL=rec_len, FORM='unformatted')
      ELSE    
         OPEN(UNIT=4,       FILE='glo_spec_kol.dat' ,ACCESS='direct', &
          RECL=rec_len, FORM='unformatted')
      ENDIF   
      his_glob(0:num_his)=0.0d0
      DO j=1,succ_runs
      read(4,REC=j)budu_tilda(0:num_his)
         SELECT CASE(kernel_type)
         CASE(0,1,2,4,5,6,7) 
             budu(0:num_his) = budu_tilda(0:num_his)    
         CASE(3) 
            CALL UN_TILDEFY(beta,num_his,om,budu_tilda,budu)
         CASE DEFAULT
            STOP'Ni figa sebe'
         END SELECT    
         his_loc(j,0:num_his)=budu(0:num_his) 
      IF( 1.0d0/po_of(j,1) >= o_low .AND. 1.0d0/po_of(j,1) <= o_high & 
         .AND. po_of(j,6) >= n_low .AND. po_of(j,6) <= n_high )THEN
      his_glob(0:num_his) &
          = his_glob(0:num_his)+his_loc(j,0:num_his)
      portu_run=portu_run+1
      ENDIF
      ENDDO; 
      CLOSE(4)
! selecting restrictions
      IF(portu_run>0)THEN
        his_glob(0:num_his)= &
        his_glob(0:num_his)/portu_run
      ELSE
      PRINT*,'Sorry, you want too much. No runs with such parameters'
      ENDIF
! writing Kolya HISTOGRAM      
      OPEN(4,FILE='final_kol.dat')
      DO j=0,num_his; 
          WRITE(4,*)om(j),'  ',his_glob(j); 
      ENDDO      
      CLOSE(4)     
! ---- K O L Y A   H I S T O G R A M   E  N D S ---------------      

      
!Defining ANZAC DATA: the average omega and z
      om_av=0.0d0; z_tota1=0.0d0;
      DO i=1,succ_runs;
       z_tota1=z_tota1+po_of(i,5)/po_of(i,6)
      ENDDO
      IF(z_tota1<1.0d-20)GOTO 777;
      DO i=1,succ_runs;
       om_av=om_av+po_of(i,4)*(po_of(i,5)/po_of(i,6))/z_tota1;
      ENDDO;
!Defining the dispersion for the first anzac
      dis_1=0.0d0;
      DO i=1,succ_runs;
       dis_1=dis_1+(om_av-po_of(i,4))**2* &
            (po_of(i,5)/po_of(i,6))/z_tota1;      
      ENDDO;
      dis_1=SQRT(dis_1)
!Defining average Z and Z-max-Z_min for the first anzac
      zz_min=HUGE(zz_min); zz_max=-HUGE(zz_max)
      z_av=0.0d0
      DO i=1,succ_runs;
        sukno=po_of(i,5)/po_of(i,6)
        z_av = z_av + sukno/succ_runs
        IF(sukno<zz_min)zz_min=sukno
        IF(sukno>zz_max)zz_max=sukno
      ENDDO
 777  CONTINUE
!Definig min-max omega value for the first anzac; 
      om_min = MINVAL(po_of(1:succ_runs,4))
      om_max = MAXVAL(po_of(1:succ_runs,4))


! PRINTING REPORT      

      PRINT*,'--------------------------------------------'
      PRINT*, 'Number of performed runs  = ', perf_runs
      PRINT*, 'Number of succesfull runs = ', succ_runs
      PRINT*, 'Number of restricted runs = ', portu_run
      PRINT*,'--------------------------------------------'
      
      PRINT'("Omega of anzac =   ",1X,ES12.5," +/- ",ES12.5)',  &
       om_av,dis_1
      PRINT'("Zfactor of anzac = ",1X,ES12.5," +/- ",ES12.5)', &
       z_av,(zz_max-zz_min)/2.0d0



 122   CONTINUE

! Check of the normalization
      DO i=1,succ_runs
      nor_ku=nor_ku+po_of(i,6)/succ_runs
      nor_ge=nor_ge+sh_his*SUM(his_loc(i,0:num_his))/succ_runs
      ENDDO
          
      PRINT*,"   "
      
      
      
! Analysing Kolya's improvement provide this is not refinement
       reff: IF(.NOT. REFINEMENT)THEN

       OPEN(UNIT=4,FILE="pomog.dat")
       READ(4,*)i_pomog
       ALLOCATE(pomog(i_pomog,2))
       DO i=1,i_pomog
          READ(4,*)ivoid,pomog(i,1),pomog(i,2)
       ENDDO    
       CLOSE(4)

       OPEN(UNIT=4,FILE="pomog_sho.dat")
       DO i=1,i_pomog
          WRITE(4,*)i,pomog(i,1),pomog(i,2)
       ENDDO    
       CLOSE(4)
       
! Making global histogram for improvement analysis
      mi_maxde=HUGE(mi_maxde); ma_maxde=0.0d0
      DO i=1,i_pomog;
        IF(pomog(i,2)<mi_maxde)mi_maxde=pomog(i,2) 
        IF(pomog(i,2)>ma_maxde)ma_maxde=pomog(i,2) 
      ENDDO      
! making histogram of improvements
!      PRINT*,ma_maxde, mi_maxde
      sha_sta=(ma_maxde-mi_maxde)/i_hissta_2;
      DO i_fli=0,i_hissta_2;
        h_maxme(i_fli)=0.0d0;
        maxme(i_fli)=mi_maxde+i_fli*sha_sta;  
      ENDDO  
      bolshe=0.0d0; menshe=0.0d0
      DO j=1,i_pomog;
        IF(pomog(j,2)>1.0d0)THEN
            bolshe=bolshe+1.0d0
        ELSE
            menshe=menshe+1.0d0
        ENDIF    
        DO i_fli=0,i_hissta_2; 
          IF(pomog(j,2)<maxme(i_fli)+sha_sta)THEN;
            h_maxme(i_fli)=h_maxme(i_fli)+1.0d0; EXIT;
          ENDIF
        ENDDO
      ENDDO            
      OPEN(7,FILE='pomog_hist.dat')
      DO i_fli=0,i_hissta_2; 
         WRITE(7,*)maxme(i_fli),'  ',h_maxme(i_fli); 
      ENDDO      
      CLOSE(7)
      
      PRINT*,"Bolshe/Menshe = ",bolshe/menshe

 ! Making imminent histogram for improvement analysis
      mi_maxde=1.0d-2; 
      ma_maxde=1.0d2
! making immminent histogram of improvements
      sha_sta=(ma_maxde-mi_maxde)/i_hissta_2;
      DO i_fli=0,i_hissta_2;
        h_maxme(i_fli)=0.0d0;
        maxme(i_fli)=mi_maxde+i_fli*sha_sta;  
      ENDDO  
      DO j=1,i_pomog;
        DO i_fli=0,i_hissta_2; 
          IF(pomog(j,2)<maxme(i_fli)+sha_sta)THEN;
            h_maxme(i_fli)=h_maxme(i_fli)+1.0d0; EXIT;
          ENDIF
        ENDDO
      ENDDO            
      OPEN(7,FILE='pomog_hist2.dat')
      DO i_fli=0,i_hissta_2; 
         WRITE(7,*)maxme(i_fli),'  ',h_maxme(i_fli); 
      ENDDO      
      CLOSE(7)

     ENDIF reff
      
      END PROGRAM statistics_analisis

!--------------------------------------------------------------------
! ordering smallest first
!--------------------------------------------------------------------
	SUBROUTINE ORDERD_SMALL(n,a,b)
    IMPLICIT NONE
    INTEGER,INTENT(IN)                        :: n
	REAL*8,DIMENSION(n),INTENT(IN)    :: a
	REAL*8,DIMENSION(n),INTENT(OUT) :: b
    
    INTEGER :: i,l; 
    REAL*8 :: x
    
    b(1:n)=a(1:n)
    
	DO i=2,n; l=i
2	   IF(b(l)>b(l-1))GOTO 1
	   x=b(l);	b(l)=b(l-1); b(l-1)=x; 
       l=l-1; 
       IF(l>=2)GOTO 2
1     CONTINUE;  
    ENDDO;
    
    END SUBROUTINE ORDERD_SMALL
!....................................................................
      
!--------------------------------------------------------------------
! ordering smallest first
!--------------------------------------------------------------------
	SUBROUTINE UN_TILDEFY(beta,n,omega,A_tilde,A)
    IMPLICIT NONE
    REAL*8,INTENT(IN) :: beta
    INTEGER,INTENT(IN)                        :: n
	REAL*8,DIMENSION(n),INTENT(IN)    :: A_tilde,omega
	REAL*8,DIMENSION(n),INTENT(OUT) :: A
    
    INTEGER :: i 
    REAL*8 :: x,eb1,eb2
    
	DO i=0,n
       x = (beta*omega(i)*0.5d0); eb1 = exp(x); eb2=1.0d0/eb1
       A(i) = ( (eb1-eb2) / (eb1+eb2) ) * A_tilde(i)
    ENDDO;
    
    END SUBROUTINE UN_TILDEFY
!....................................................................
      
